/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.compat.IPPortingLibCompat;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.FrontClipping;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.SecondaryFrameBuffer;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;

public class RendererUsingFrameBuffer
extends PortalRenderer {
    SecondaryFrameBuffer secondaryFrameBuffer = new SecondaryFrameBuffer();

    @Override
    public void onBeforeTranslucentRendering(PoseStack matrixStack) {
        this.renderPortals(matrixStack);
    }

    @Override
    public void onAfterTranslucentRendering(PoseStack matrixStack) {
    }

    @Override
    public void onHandRenderingEnded(PoseStack matrixStack) {
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public void prepareRendering() {
        this.secondaryFrameBuffer.prepare();
        GlStateManager._enableDepthTest();
        GL11.glDisable((int)2960);
        IPPortingLibCompat.setIsStencilEnabled(client.m_91385_(), false);
    }

    protected void doRenderPortal(PortalRenderable portal, PoseStack matrixStack) {
        if (PortalRendering.isRendering()) {
            return;
        }
        if (!this.testShouldRenderPortal(portal, matrixStack)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal.getPortalLike());
        RenderTarget oldFrameBuffer = client.m_91385_();
        ((IEMinecraftClient)client).setFrameBuffer((RenderTarget)this.secondaryFrameBuffer.fb);
        this.secondaryFrameBuffer.fb.m_83947_(true);
        GlStateManager._clearColor((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._clear((int)16640, (boolean)Minecraft.f_91002_);
        GL11.glDisable((int)2960);
        this.renderPortalContent(portal);
        ((IEMinecraftClient)client).setFrameBuffer(oldFrameBuffer);
        oldFrameBuffer.m_83947_(true);
        PortalRendering.popPortalLayer();
        CHelper.enableDepthClamp();
        this.renderSecondBufferIntoMainBuffer(portal, matrixStack);
        CHelper.disableDepthClamp();
        MyRenderHelper.debugFramebufferDepth();
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        return false;
    }

    private boolean testShouldRenderPortal(PortalRenderable portal, PoseStack matrixStack) {
        FrontClipping.updateInnerClipping(matrixStack);
        return QueryManager.renderAndGetDoesAnySamplePass(() -> ViewAreaRenderer.renderPortalArea(portal, Vec3.f_82478_, matrixStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), true, true, true, true));
    }

    private void renderSecondBufferIntoMainBuffer(PortalRenderable portal, PoseStack matrixStack) {
        MyRenderHelper.drawPortalAreaWithFramebuffer(portal, (RenderTarget)this.secondaryFrameBuffer.fb, matrixStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix());
    }

    protected void renderPortals(PoseStack matrixStack) {
        List<PortalRenderable> portalsToRender = this.getPortalsToRender(matrixStack);
        for (PortalRenderable portal : portalsToRender) {
            this.doRenderPortal(portal, matrixStack);
        }
    }
}

